import {ChangeDetectionStrategy, Component, Inject,} from "@angular/core";
import {MAT_DIALOG_DATA, MatDialogRef,} from "@angular/material";
import {adminOrgUnitActionNameSpace} from "@admin/orgunit/stores/admin-organizational-unit.action";
import {AdminOrganizationalUnitStateModel} from "@admin/orgunit/stores/admin-organizational-unit.state";
import {OrganizationalUnitExtended} from "@deposit/models/organizational-unit-extended.model";
import {SharedAbstractDeleteDialog} from "@shared/components/dialogs/shared-abstract-delete/shared-abstract-delete.dialog";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {DeleteDialog} from "@shared/models/delete-dialog.model";
import {Store} from "@ngxs/store";
import {TRANSLATE} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-orgunit-delete-dialog",
  templateUrl: "../../../../../shared/components/dialogs/shared-abstract-delete/shared-abstract-delete.dialog.html",
  styleUrls: ["../../../../../shared/components/dialogs/shared-abstract-delete/shared-abstract-delete.dialog.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminOrgunitDeleteDialog extends SharedAbstractDeleteDialog<OrganizationalUnitExtended, AdminOrganizationalUnitStateModel> {
  public readonly KEY_TITLE: string = TRANSLATE("admin.organizationalUnit.dialog.delete.title");
  public readonly KEY_MESSAGE: string = TRANSLATE("admin.organizationalUnit.dialog.delete.message");
  public readonly KEY_CONFIRM_BUTTON: string = TRANSLATE("admin.organizationalUnit.dialog.delete.confirm");
  public readonly KEY_CANCEL_BUTTON: string = TRANSLATE("admin.organizationalUnit.dialog.delete.cancel");

  constructor(protected store: Store,
              protected dialogRef: MatDialogRef<AdminOrgunitDeleteDialog>,
              @Inject(MAT_DIALOG_DATA) public data: DeleteDialog) {
    super(store, dialogRef, data, LocalStateEnum.admin_organizationalUnit, adminOrgUnitActionNameSpace);
  }
}
