import {adminOAuth2ClientActionNameSpace} from "@admin/oauth2-client/stores/admin-oauth2-client.action";
import {Oauth2Client} from "@app/generated-api";
import {AdminResourceApiEnum} from "@shared/enums/api.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {RoutesEnum} from "@shared/enums/routes.enum";
import {Actions, State, Store,} from "@ngxs/store";
import {
  ApiService,
  defaultResourceStateInitValue,
  NotificationService,
  ResourceState,
  ResourceStateModel,
  TRANSLATE,
} from "solidify-frontend";

export interface AdminOAuth2ClientStateModel extends ResourceStateModel<Oauth2Client> {
}

@State<AdminOAuth2ClientStateModel>({
  name: LocalStateEnum.admin_oauth2Client,
  defaults: {
    ...defaultResourceStateInitValue,
  },
})
export class AdminOAuth2ClientState extends ResourceState<Oauth2Client> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: adminOAuth2ClientActionNameSpace,
      urlResource: AdminResourceApiEnum.oauth2Clients,
      routeRedirectUrlAfterSuccessAction: RoutesEnum.admin,
      notificationResourceCreateTextToTranslate: TRANSLATE("admin.oauth2.notification.resource.create"),
      notificationResourceDeleteTextToTranslate: TRANSLATE("admin.oauth2.notification.resource.delete"),
      notificationResourceUpdateTextToTranslate: TRANSLATE("admin.oauth2.notification.resource.update"),
    });
  }
}
