import {SubmissionPolicy} from "@app/generated-api";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {ResourceAction, ResourceNameSpace, TypeDefaultAction,} from "solidify-frontend";

const state = LocalStateEnum.admin_oauth2Client;

export namespace AdminOAuth2ClientAction {
  @TypeDefaultAction(state)
  export class LoadResource extends ResourceAction.LoadResource {
  }

  @TypeDefaultAction(state)
  export class LoadResourceSuccess extends ResourceAction.LoadResourceSuccess {
  }

  @TypeDefaultAction(state)
  export class LoadResourceFail extends ResourceAction.LoadResourceFail {
  }

  @TypeDefaultAction(state)
  export class ChangeQueryParameters extends ResourceAction.ChangeQueryParameters {
  }

  @TypeDefaultAction(state)
  export class GetAll extends ResourceAction.GetAll {
  }

  @TypeDefaultAction(state)
  export class GetAllSuccess extends ResourceAction.GetAllSuccess<SubmissionPolicy> {
  }

  @TypeDefaultAction(state)
  export class GetAllFail extends ResourceAction.GetAllFail<SubmissionPolicy> {
  }

  @TypeDefaultAction(state)
  export class GetById extends ResourceAction.GetById {
  }

  @TypeDefaultAction(state)
  export class GetByIdSuccess extends ResourceAction.GetByIdSuccess<SubmissionPolicy> {
  }

  @TypeDefaultAction(state)
  export class GetByIdFail extends ResourceAction.GetByIdFail<SubmissionPolicy> {
  }

  @TypeDefaultAction(state)
  export class Create extends ResourceAction.Create<SubmissionPolicy> {
  }

  @TypeDefaultAction(state)
  export class CreateSuccess extends ResourceAction.CreateSuccess<SubmissionPolicy> {
  }

  @TypeDefaultAction(state)
  export class CreateFail extends ResourceAction.CreateFail<SubmissionPolicy> {
  }

  @TypeDefaultAction(state)
  export class Update extends ResourceAction.Update<SubmissionPolicy> {
  }

  @TypeDefaultAction(state)
  export class UpdateSuccess extends ResourceAction.UpdateSuccess<SubmissionPolicy> {
  }

  @TypeDefaultAction(state)
  export class UpdateFail extends ResourceAction.UpdateFail<SubmissionPolicy> {
  }

  @TypeDefaultAction(state)
  export class Delete extends ResourceAction.Delete {
  }

  @TypeDefaultAction(state)
  export class DeleteSuccess extends ResourceAction.DeleteSuccess {
  }

  @TypeDefaultAction(state)
  export class DeleteFail extends ResourceAction.DeleteFail {
  }
}

export const adminOAuth2ClientActionNameSpace: ResourceNameSpace = AdminOAuth2ClientAction;
