import {NgModule} from "@angular/core";
import {SharedModule} from "@app/shared/shared.module";
import {TranslateModule} from "@ngx-translate/core";
import {NgxsModule} from "@ngxs/store";
import {AdminOAuth2ClientState} from "@admin/oauth2-client/stores/admin-oauth2-client.state";
import {AdminOauth2ClientRoutingModule} from "@admin/oauth2-client/oauth2-client-routing.module";
import {AdminOAuth2ClientListRoutable} from "@admin/oauth2-client/components/routables/list/admin-oauth2-client-list-routable.component";
import {AdminOAuth2ClientDetailRoutable} from "@admin/oauth2-client/components/routables/detail/admin-oauth2-client-detail.routable";
import {AdminOAuth2ClientEditRoutable} from "@admin/oauth2-client/components/routables/edit/admin-oauth2-client-edit-routable";
import {AdminOAuth2ClientCreateRoutable} from "@admin/oauth2-client/components/routables/create/admin-oauth2-client-create-routable";
import {AdminOauth2ClientDeleteDialog} from "@admin/oauth2-client/components/dialogs/admin-oauth2-client-delete.dialog";
import {AdminOAtuh2ClientFormPresentational} from "@admin/oauth2-client/components/presentationals/admin-oauth2-client-form.presentational";

const routables = [
  AdminOAuth2ClientListRoutable,
  AdminOAuth2ClientDetailRoutable,
  AdminOAuth2ClientEditRoutable,
  AdminOAuth2ClientCreateRoutable,
];
const containers = [];
const dialogs = [
  AdminOauth2ClientDeleteDialog,
];
const presentationals = [
  AdminOAtuh2ClientFormPresentational,
];

@NgModule({
  declarations: [
    ...routables,
    ...containers,
    ...dialogs,
    ...presentationals,
  ],
  imports: [
    SharedModule,
    AdminOauth2ClientRoutingModule,
    TranslateModule.forChild({}),
    NgxsModule.forFeature([
      AdminOAuth2ClientState
    ]),
  ],
  entryComponents: [
    ...dialogs,
  ],
  exports: [
    ...routables,
  ],
  providers: [],
})
export class AdminOauth2ClientModule { }
