import {NgModule} from "@angular/core";
import {RouterModule, Routes} from "@angular/router";
import {AdminRoutesEnum, AppRoutesEnum} from "@shared/enums/routes.enum";
import {AdminOAuth2ClientListRoutable} from "@admin/oauth2-client/components/routables/list/admin-oauth2-client-list-routable.component";
import {TRANSLATE} from "solidify-frontend";
import {AdminOAuth2ClientCreateRoutable} from "@admin/oauth2-client/components/routables/create/admin-oauth2-client-create-routable";
import {AdminOAuth2ClientDetailRoutable} from "@admin/oauth2-client/components/routables/detail/admin-oauth2-client-detail.routable";
import {AdminOAuth2ClientEditRoutable} from "@admin/oauth2-client/components/routables/edit/admin-oauth2-client-edit-routable";

const routes: Routes = [
  {
    path: AppRoutesEnum.root,
    component: AdminOAuth2ClientListRoutable,
    data: {
      breadcrumb: TRANSLATE("breadcrumb.admin.oauth2Client.list"),
    },
  },
  {
    component: AdminOAuth2ClientCreateRoutable,
    path: AdminRoutesEnum.oauth2clientCreate,
    data: {
      breadcrumb: TRANSLATE("breadcrumb.admin.oauth2Client.create"),
    },
  },
  {
    path: AdminRoutesEnum.oauth2clientDetail + AppRoutesEnum.separator + AppRoutesEnum.paramId,
    component: AdminOAuth2ClientDetailRoutable,
    data: {
      breadcrumb: TRANSLATE("breadcrumb.admin.oauth2Client.detail"),
    },
  },
  {
    path: AdminRoutesEnum.oauth2clientEdit + AppRoutesEnum.separator + AppRoutesEnum.paramId,
    component: AdminOAuth2ClientEditRoutable,
    data: {
      breadcrumb: TRANSLATE("breadcrumb.admin.oauth2Client.edit"),
    },
  },

];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class AdminOauth2ClientRoutingModule { }
