import {ChangeDetectionStrategy, Component,} from "@angular/core";
import {adminOAuth2ClientActionNameSpace} from "@admin/oauth2-client/stores/admin-oauth2-client.action";
import {AdminOAuth2ClientStateModel} from "@admin/oauth2-client/stores/admin-oauth2-client.state";
import {Oauth2Client} from "@app/generated-api";
import {SharedAbstractListRoutable} from "@shared/components/routables/shared-abstract-list/shared-abstract-list.routable";
import {FieldTypeEnum} from "@shared/enums/field-type.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {Store} from "@ngxs/store";
import {TRANSLATE} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-submission-policy-list-routable",
  templateUrl: "../../../../../../shared/components/routables/shared-abstract-list/shared-abstract-list.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-list/shared-abstract-list.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminOAuth2ClientListRoutable extends SharedAbstractListRoutable<Oauth2Client, AdminOAuth2ClientStateModel> {
  readonly KEY_CREATE_BUTTON: string = TRANSLATE("admin.oauth2.button.new");
  readonly KEY_REFRESH_BUTTON: string = TRANSLATE("admin.oauth2.button.refresh");

  constructor(protected store: Store) {
    super(store, LocalStateEnum.admin_oauth2Client, adminOAuth2ClientActionNameSpace, {}, LocalStateEnum.admin);
  }

  defineColumns(): void {
    this.columns = [
      {
        field: "name",
        header: TRANSLATE("admin.oauth2.table.header.name"),
        type: FieldTypeEnum.string,
        order: 0,
        isFilterable: true,
        isSortable: true,
      },
      {
        field: "clientId",
        header: TRANSLATE("admin.oauth2.table.header.clientId"),
        type: FieldTypeEnum.string,
        order: 0,
        isFilterable: true,
        isSortable: true,
      },
      {
        field: "redirectUri",
        header: TRANSLATE("admin.oauth2.table.header.redirectUri"),
        type: FieldTypeEnum.string,
        order: 0,
        isFilterable: true,
        isSortable: true,
      },
    ];
  }
}
