import {ChangeDetectionStrategy, Component, OnInit,} from "@angular/core";
import {ActivatedRoute} from "@angular/router";
import {adminOAuth2ClientActionNameSpace} from "@admin/oauth2-client/stores/admin-oauth2-client.action";
import {AdminOAuth2ClientStateModel} from "@admin/oauth2-client/stores/admin-oauth2-client.state";
import {Oauth2Client} from "@app/generated-api";
import {SharedAbstractEditRoutable} from "@shared/components/routables/shared-abstract-edit/shared-abstract-edit.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {Store} from "@ngxs/store";

@Component({
  selector: "dlcm-admin-oauth2-client-edit-routable",
  templateUrl: "./admin-oauth2-client-edit-routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-edit/shared-abstract-edit.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminOAuth2ClientEditRoutable extends SharedAbstractEditRoutable<Oauth2Client, AdminOAuth2ClientStateModel> implements OnInit {
  constructor(protected store: Store,
              protected route: ActivatedRoute) {
    super(store, route, LocalStateEnum.admin_oauth2Client, adminOAuth2ClientActionNameSpace, LocalStateEnum.admin);
  }

  ngOnInit(): void {
    super.ngOnInit();
  }

  getSubResourceWithParentId(id: string): void {
  }
}
