import {ChangeDetectionStrategy, Component, OnInit, ViewChild,} from "@angular/core";
import {adminOAuth2ClientActionNameSpace} from "@admin/oauth2-client/stores/admin-oauth2-client.action";
import {AdminOAuth2ClientStateModel} from "@admin/oauth2-client/stores/admin-oauth2-client.state";
import {Oauth2Client} from "@app/generated-api";
import {SharedAbstractFormPresentational} from "@shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational";
import {SharedAbstractCreateRoutable} from "@shared/components/routables/shared-abstract-create/shared-abstract-create.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {Store} from "@ngxs/store";

@Component({
  selector: "dlcm-admin-oauth2-create-routable",
  templateUrl: "./admin-oauth2-client-create-routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-create/shared-abstract-create.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminOAuth2ClientCreateRoutable extends SharedAbstractCreateRoutable<Oauth2Client, AdminOAuth2ClientStateModel> implements OnInit {
  @ViewChild("formPresentational", {static: false})
  readonly formPresentational: SharedAbstractFormPresentational<Oauth2Client>;

  constructor(protected store: Store) {
    super(store, LocalStateEnum.admin_oauth2Client, adminOAuth2ClientActionNameSpace, LocalStateEnum.admin);
  }

  ngOnInit(): void {
    super.ngOnInit();
  }
}
