import {ChangeDetectionStrategy, Component, Inject,} from "@angular/core";
import {MAT_DIALOG_DATA, MatDialogRef,} from "@angular/material";
import {adminOAuth2ClientActionNameSpace} from "@admin/oauth2-client/stores/admin-oauth2-client.action";
import {AdminOAuth2ClientStateModel} from "@admin/oauth2-client/stores/admin-oauth2-client.state";
import {Oauth2Client} from "@app/generated-api";
import {SharedAbstractDeleteDialog} from "@shared/components/dialogs/shared-abstract-delete/shared-abstract-delete.dialog";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {DeleteDialog} from "@shared/models/delete-dialog.model";
import {Store} from "@ngxs/store";
import {TRANSLATE} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-orgunit-delete-dialog",
  templateUrl: "../../../../../shared/components/dialogs/shared-abstract-delete/shared-abstract-delete.dialog.html",
  styleUrls: ["../../../../../shared/components/dialogs/shared-abstract-delete/shared-abstract-delete.dialog.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminOauth2ClientDeleteDialog extends SharedAbstractDeleteDialog<Oauth2Client, AdminOAuth2ClientStateModel> {
  public readonly KEY_TITLE: string = TRANSLATE("admin.oauth2.dialog.delete.title");
  public readonly KEY_MESSAGE: string = TRANSLATE("admin.oauth2.dialog.delete.message");
  public readonly KEY_CONFIRM_BUTTON: string = TRANSLATE("admin.oauth2.dialog.delete.confirm");
  public readonly KEY_CANCEL_BUTTON: string = TRANSLATE("admin.oauth2.dialog.delete.cancel");

  constructor(protected store: Store,
              protected dialogRef: MatDialogRef<AdminOauth2ClientDeleteDialog>,
              @Inject(MAT_DIALOG_DATA) public data: DeleteDialog) {
    super(store, dialogRef, data, LocalStateEnum.admin_oauth2Client, adminOAuth2ClientActionNameSpace);
  }
}
