import {adminLicenseActionNameSpace} from "@admin/license/stores/admin-license.action";
import {License} from "@app/generated-api";
import {AdminResourceApiEnum} from "@shared/enums/api.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {RoutesEnum} from "@shared/enums/routes.enum";
import {Actions, State, Store,} from "@ngxs/store";
import {
  ApiService,
  defaultResourceStateInitValue,
  NotificationService,
  ResourceState,
  ResourceStateModel,
  TRANSLATE,
} from "solidify-frontend";

export interface AdminLicenseStateModel extends ResourceStateModel<License> {
}

@State<AdminLicenseStateModel>({
  name: LocalStateEnum.admin_license,
  defaults: {
    ...defaultResourceStateInitValue,
  },
})
export class AdminLicenseState extends ResourceState<License> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: adminLicenseActionNameSpace,
      urlResource: AdminResourceApiEnum.licenses,
      routeRedirectUrlAfterSuccessAction: RoutesEnum.adminLicense,
      notificationResourceCreateTextToTranslate: TRANSLATE("admin.license.notification.resource.create"),
      notificationResourceDeleteTextToTranslate: TRANSLATE("admin.license.notification.resource.delete"),
      notificationResourceUpdateTextToTranslate: TRANSLATE("admin.license.notification.resource.update"),
    });
  }
}
