import {NgModule} from "@angular/core";
import {AdminLicenseDeleteDialog} from "@admin/license/components/dialogs/admin-license-delete.dialog";
import {AdminLicenseFormPresentational} from "@admin/license/components/presentationals/admin-license-form.presentational";
import {AdminLicenseCreateRoutable} from "@app/features/admin/license/components/routables/create/admin-license-create.routable";
import {AdminLicenseDetailRoutable} from "@app/features/admin/license/components/routables/detail/admin-license-detail.routable";
import {AdminLicenseEditRoutable} from "@app/features/admin/license/components/routables/edit/admin-license-edit.routable";
import {AdminLicenseListRoutable} from "@app/features/admin/license/components/routables/list/admin-license-list.routable";
import {AdminLicenseState} from "@admin/license/stores/admin-license.state";
import {SharedModule} from "@app/shared/shared.module";
import {TranslateModule} from "@ngx-translate/core";
import {NgxsModule} from "@ngxs/store";
import {AdminLicenseRoutingModule} from "@admin/license/license-routing.module";

const routables = [
  AdminLicenseCreateRoutable,
  AdminLicenseDetailRoutable,
  AdminLicenseEditRoutable,
  AdminLicenseListRoutable,
];
const containers = [];
const dialogs = [
  AdminLicenseDeleteDialog
];
const presentationals = [
  AdminLicenseFormPresentational
];

@NgModule({
  declarations: [
    ...routables,
    ...containers,
    ...dialogs,
    ...presentationals,
  ],
  imports: [
    SharedModule,
    AdminLicenseRoutingModule,
    TranslateModule.forChild({}),
    NgxsModule.forFeature([
      AdminLicenseState
    ]),
  ],
  entryComponents: [
    ...dialogs,
  ],
  exports: [
    ...routables,
  ],
  providers: [],
})
export class AdminLicenseModule {
}
