import {NgModule} from "@angular/core";
import {RouterModule, Routes} from "@angular/router";
import {AdminRoutesEnum, AppRoutesEnum} from "@shared/enums/routes.enum";
import {TRANSLATE} from "solidify-frontend";
import {AdminLicenseCreateRoutable} from "@admin/license/components/routables/create/admin-license-create.routable";
import {AdminLicenseEditRoutable} from "@admin/license/components/routables/edit/admin-license-edit.routable";
import {AdminLicenseDetailRoutable} from "@admin/license/components/routables/detail/admin-license-detail.routable";
import {AdminLicenseListRoutable} from "@admin/license/components/routables/list/admin-license-list.routable";

const routes: Routes = [
  {
    path: AppRoutesEnum.root,
    component: AdminLicenseListRoutable,
    data: {
      breadcrumb: TRANSLATE("breadcrumb.admin.license.list"),
    },
  },
  {
    path: AdminRoutesEnum.licenseCreate,
    component: AdminLicenseCreateRoutable,
    data: {
      breadcrumb: TRANSLATE("breadcrumb.admin.license.create"),
    },
  },
  {
    path: AdminRoutesEnum.licenseEdit + AppRoutesEnum.separator + AppRoutesEnum.paramId,
    component: AdminLicenseEditRoutable,
    data: {
      breadcrumb: TRANSLATE("breadcrumb.admin.license.edit"),
    },
  },
  {
    path: AdminRoutesEnum.licenseDetail + AppRoutesEnum.separator + AppRoutesEnum.paramId,
    component: AdminLicenseDetailRoutable,
    data: {
      breadcrumb: TRANSLATE("breadcrumb.admin.license.detail"),
    },
  }
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class AdminLicenseRoutingModule { }
