import {ChangeDetectionStrategy, Component,} from "@angular/core";
import {adminLicenseActionNameSpace} from "@admin/license/stores/admin-license.action";
import {AdminLicenseStateModel} from "@admin/license/stores/admin-license.state";
import {License} from "@app/generated-api";
import {SharedAbstractListRoutable} from "@shared/components/routables/shared-abstract-list/shared-abstract-list.routable";
import {FieldTypeEnum} from "@shared/enums/field-type.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {Store} from "@ngxs/store";
import {TRANSLATE} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-license-list-routable",
  templateUrl: "../../../../../../shared/components/routables/shared-abstract-list/shared-abstract-list.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-list/shared-abstract-list.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminLicenseListRoutable extends SharedAbstractListRoutable<License, AdminLicenseStateModel> {
  readonly KEY_CREATE_BUTTON: string = TRANSLATE("admin.license.button.new");
  readonly KEY_REFRESH_BUTTON: string = TRANSLATE("admin.license.button.refresh");

  constructor(protected store: Store) {
    super(store, LocalStateEnum.admin_license, adminLicenseActionNameSpace, {}, LocalStateEnum.admin);
  }

  defineColumns(): void {
    this.columns = [
      {
        field: "title",
        header: TRANSLATE("admin.license.table.header.name"),
        type: FieldTypeEnum.string,
        order: 0,
        isFilterable: true,
        isSortable: true,
      },
    ];
  }
}
