import {ChangeDetectionStrategy, Component,} from "@angular/core";
import {MatDialog} from "@angular/material";
import {ActivatedRoute} from "@angular/router";
import {adminLicenseActionNameSpace} from "@admin/license/stores/admin-license.action";
import {AdminLicenseStateModel} from "@admin/license/stores/admin-license.state";
import {License} from "@app/generated-api";
import {SharedAbstractDetailRoutable} from "@shared/components/routables/shared-abstract-detail/shared-abstract-detail.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {Store} from "@ngxs/store";
import {TRANSLATE} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-license-detail-routable",
  templateUrl: "./admin-license-detail.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-detail/shared-abstract-detail.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminLicenseDetailRoutable extends SharedAbstractDetailRoutable<License, AdminLicenseStateModel> {
  readonly KEY_PARAM_NAME: string = "name";
  readonly KEY_DELETE_BUTTON: string = TRANSLATE("admin.license.button.delete");
  readonly KEY_EDIT_BUTTON: string = TRANSLATE("admin.license.button.edit");

  constructor(protected store: Store,
              protected route: ActivatedRoute,
              public dialog: MatDialog) {
    super(store, route, dialog, LocalStateEnum.admin_license, adminLicenseActionNameSpace, LocalStateEnum.admin);
  }

  getSubResourceWithParentId(id: string): void {
  }
}
