import {ChangeDetectionStrategy, Component, ViewChild,} from "@angular/core";
import {adminLicenseActionNameSpace} from "@admin/license/stores/admin-license.action";
import {AdminLicenseStateModel} from "@admin/license/stores/admin-license.state";
import {License} from "@app/generated-api";
import {SharedAbstractFormPresentational} from "@shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational";
import {SharedAbstractCreateRoutable} from "@shared/components/routables/shared-abstract-create/shared-abstract-create.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {Store} from "@ngxs/store";

@Component({
  selector: "dlcm-admin-license-create-routable",
  templateUrl: "./admin-license-create.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-create/shared-abstract-create.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminLicenseCreateRoutable extends SharedAbstractCreateRoutable<License, AdminLicenseStateModel> {
  @ViewChild("formPresentational", {static: false})
  readonly formPresentational: SharedAbstractFormPresentational<License>;

  constructor(protected store: Store) {
    super(store, LocalStateEnum.admin_license, adminLicenseActionNameSpace, LocalStateEnum.admin);
  }
}
