import {ChangeDetectionStrategy, ChangeDetectorRef, Component,} from "@angular/core";
import {FormBuilder, Validators,} from "@angular/forms";
import {License} from "@app/generated-api";
import {SharedAbstractFormPresentational} from "@shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational";
import {odConformanceEnum, osdConformanceEnum,} from "@shared/enums/license.enums";
import {BaseFormDefinition} from "@shared/models/base-form-definition.model";
import {EnumUtil, PropertyName, SolidifyValidator,} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-license-form",
  templateUrl: "./admin-license-form.presentational.html",
  styleUrls: ["../../../../../shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminLicenseFormPresentational extends SharedAbstractFormPresentational<License> {
  formDefinition: FormComponentFormDefinition = new FormComponentFormDefinition();

  licensesStatusEnum: License.StatusEnum[] = EnumUtil.convertToArray(License.StatusEnum);
  licenseOdConformanceEnum: odConformanceEnum[] = EnumUtil.convertToArray(odConformanceEnum);
  licenseOsdConformanceEnum: osdConformanceEnum[] = EnumUtil.convertToArray(osdConformanceEnum);

  constructor(protected readonly _changeDetectorRef: ChangeDetectorRef,
              private readonly _fb: FormBuilder) {
    super(_changeDetectorRef);
  }

  protected initNewForm(): void {
    this.form = this._fb.group({
      [this.formDefinition.title]: ["", [Validators.required, SolidifyValidator]],
      [this.formDefinition.openLicenseId]: ["", [Validators.required, SolidifyValidator]],
      [this.formDefinition.url]: ["", [SolidifyValidator]],
      [this.formDefinition.maintainer]: ["", [SolidifyValidator]],
      [this.formDefinition.odConformance]: ["", [SolidifyValidator]],
      [this.formDefinition.osdConformance]: ["", [SolidifyValidator]],
      [this.formDefinition.status]: [License.StatusEnum.Retired, [SolidifyValidator]],
      [this.formDefinition.isGeneric]: [false, [SolidifyValidator]],
      [this.formDefinition.family]: ["", [SolidifyValidator]],
      [this.formDefinition.domainContent]: [false, [SolidifyValidator]],
      [this.formDefinition.domainData]: [false, [SolidifyValidator]],
      [this.formDefinition.domainSoftware]: [false, [SolidifyValidator]],
    });
  }

  protected bindFormTo(licenses: License): void {
    this.form = this._fb.group({
      [this.formDefinition.title]: [licenses.title, [Validators.required, SolidifyValidator]],
      [this.formDefinition.openLicenseId]: [licenses.openLicenseId, [Validators.required, SolidifyValidator]],
      [this.formDefinition.url]: [licenses.url, [SolidifyValidator]],
      [this.formDefinition.maintainer]: [licenses.maintainer, [SolidifyValidator]],
      [this.formDefinition.odConformance]: [licenses.odConformance, [SolidifyValidator]],
      [this.formDefinition.osdConformance]: [licenses.osdConformance, [SolidifyValidator]],
      [this.formDefinition.status]: [licenses.status, [Validators.required, SolidifyValidator]],
      [this.formDefinition.isGeneric]: [licenses.isGeneric, [SolidifyValidator]],
      [this.formDefinition.family]: [licenses.family, [SolidifyValidator]],
      [this.formDefinition.domainContent]: [licenses.domainContent, [SolidifyValidator]],
      [this.formDefinition.domainData]: [licenses.domainData, [SolidifyValidator]],
      [this.formDefinition.domainSoftware]: [licenses.domainSoftware, [SolidifyValidator]],
    });
  }

  protected treatmentBeforeSubmit(licenses: License): License {
    return licenses;
  }

}

class FormComponentFormDefinition extends BaseFormDefinition {
  @PropertyName() title: string;
  @PropertyName() openLicenseId: string;
  @PropertyName() url: string;
  @PropertyName() maintainer: string;
  @PropertyName() odConformance: string;
  @PropertyName() osdConformance: string;
  @PropertyName() status: string;
  @PropertyName() isGeneric: string;
  @PropertyName() family: string;
  @PropertyName() domainContent: string;
  @PropertyName() domainData: string;
  @PropertyName() domainSoftware: string;
}
