import {ChangeDetectionStrategy, Component, Inject,} from "@angular/core";
import {MAT_DIALOG_DATA, MatDialogRef,} from "@angular/material";
import {adminLicenseActionNameSpace} from "@admin/license/stores/admin-license.action";
import {AdminLicenseStateModel} from "@admin/license/stores/admin-license.state";
import {License} from "@app/generated-api";
import {SharedAbstractDeleteDialog} from "@shared/components/dialogs/shared-abstract-delete/shared-abstract-delete.dialog";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {DeleteDialog} from "@shared/models/delete-dialog.model";
import {Store} from "@ngxs/store";
import {TRANSLATE} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-license-delete-dialog",
  templateUrl: "../../../../../shared/components/dialogs/shared-abstract-delete/shared-abstract-delete.dialog.html",
  styleUrls: ["../../../../../shared/components/dialogs/shared-abstract-delete/shared-abstract-delete.dialog.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminLicenseDeleteDialog extends SharedAbstractDeleteDialog<License, AdminLicenseStateModel> {
  public readonly KEY_TITLE: string = TRANSLATE("admin.license.dialog.delete.title");
  public readonly KEY_MESSAGE: string = TRANSLATE("admin.license.dialog.delete.message");
  public readonly KEY_CONFIRM_BUTTON: string = TRANSLATE("admin.license.dialog.delete.confirm");
  public readonly KEY_CANCEL_BUTTON: string = TRANSLATE("admin.license.dialog.delete.cancel");

  constructor(protected store: Store,
              protected dialogRef: MatDialogRef<AdminLicenseDeleteDialog>,
              @Inject(MAT_DIALOG_DATA) public data: DeleteDialog) {
    super(store, dialogRef, data, LocalStateEnum.admin_license, adminLicenseActionNameSpace);
  }

}
