import {adminInstitutionActionNameSpace} from "@admin/institution/stores/admin-institution.action";
import {Institution} from "@app/generated-api";
import {AdminResourceApiEnum} from "@shared/enums/api.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {RoutesEnum} from "@shared/enums/routes.enum";
import {Actions, State, Store,} from "@ngxs/store";
import {
  ApiService,
  defaultResourceStateInitValue,
  NotificationService,
  ResourceState,
  ResourceStateModel,
  TRANSLATE,
} from "solidify-frontend";

export interface AdminInstitutionStateModel extends ResourceStateModel<Institution> {

}

@State<AdminInstitutionStateModel>({
  name: LocalStateEnum.admin_institution,
  defaults: {
    ...defaultResourceStateInitValue,
  },
})
export class AdminInstitutionState extends ResourceState<Institution> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: adminInstitutionActionNameSpace,
      urlResource: AdminResourceApiEnum.institutions,
      routeRedirectUrlAfterSuccessAction: RoutesEnum.adminInstitution,
      notificationResourceCreateTextToTranslate: TRANSLATE("admin.institution.notification.resource.create"),
      notificationResourceDeleteTextToTranslate: TRANSLATE("admin.institution.notification.resource.delete"),
      notificationResourceUpdateTextToTranslate: TRANSLATE("admin.institution.notification.resource.update"),
    });
  }
}
