import {NgModule} from "@angular/core";
import {SharedModule} from "@app/shared/shared.module";
import {TranslateModule} from "@ngx-translate/core";
import {NgxsModule} from "@ngxs/store";
import {AdminInstitutionListRoutable} from "@admin/institution/components/routables/list/admin-institution-list-routable.component";
import {AdminInstitutionDetailRoutable} from "@admin/institution/components/routables/detail/admin-institution-detail.routable";
import {AdminInstitutionEditRoutable} from "@admin/institution/components/routables/edit/admin-institution-edit.routable";
import {AdminInstitutionCreateRoutable} from "@admin/institution/components/routables/create/admin-institution-create.routable";
import {AdminInstitutionDeleteDialog} from "@admin/institution/components/dialogs/admin-institution-delete.dialog";
import {AdminInstitutionFormPresentational} from "@admin/institution/components/presentationals/admin-institution-form.presentational";
import {AdminInstitutionState} from "@admin/institution/stores/admin-institution.state";
import {AdminInstitutionRoutingModule} from "@admin/institution/institution-routing.module";

const routables = [
  AdminInstitutionListRoutable,
  AdminInstitutionDetailRoutable,
  AdminInstitutionEditRoutable,
  AdminInstitutionCreateRoutable,
];
const containers = [];
const dialogs = [
  AdminInstitutionDeleteDialog
];
const presentationals = [
  AdminInstitutionFormPresentational
];

@NgModule({
  declarations: [
    ...routables,
    ...containers,
    ...dialogs,
    ...presentationals,
  ],
  imports: [
    SharedModule,
    AdminInstitutionRoutingModule,
    TranslateModule.forChild({}),
    NgxsModule.forFeature([
      AdminInstitutionState
    ]),
  ],
  entryComponents: [
    ...dialogs,
  ],
  exports: [
    ...routables,
  ],
  providers: [],
})
export class AdminInstitutionModule {
}
