import {NgModule} from "@angular/core";
import {AdminRoutesEnum, AppRoutesEnum} from "@shared/enums/routes.enum";
import {AdminInstitutionListRoutable} from "@admin/institution/components/routables/list/admin-institution-list-routable.component";
import {TRANSLATE} from "solidify-frontend";
import {AdminInstitutionDetailRoutable} from "@admin/institution/components/routables/detail/admin-institution-detail.routable";
import {AdminInstitutionCreateRoutable} from "@admin/institution/components/routables/create/admin-institution-create.routable";
import {AdminInstitutionEditRoutable} from "@admin/institution/components/routables/edit/admin-institution-edit.routable";
import {RouterModule, Routes} from "@angular/router";

const routes: Routes = [
  {
    path: AppRoutesEnum.root,
    component: AdminInstitutionListRoutable,
    data: {
      breadcrumb: TRANSLATE("breadcrumb.admin.institution.list"),
    },
  },
  {
    path: AdminRoutesEnum.institutionDetail + AppRoutesEnum.separator + AppRoutesEnum.paramId,
    component: AdminInstitutionDetailRoutable,
    data: {
      breadcrumb: TRANSLATE("breadcrumb.admin.institution.detail"),
    },
  },
  {
    path: AdminRoutesEnum.institutionCreate,
    component: AdminInstitutionCreateRoutable,
    data: {
      breadcrumb: TRANSLATE("breadcrumb.admin.institution.create"),
    },
  },
  {
    path: AdminRoutesEnum.institutionEdit + AppRoutesEnum.separator + AppRoutesEnum.paramId,
    component: AdminInstitutionEditRoutable,
    data: {
      breadcrumb: TRANSLATE("breadcrumb.admin.institution.edit"),
    },
  }
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class AdminInstitutionRoutingModule {
}
