import {ChangeDetectionStrategy, Component,} from "@angular/core";
import {adminInstitutionActionNameSpace} from "@admin/institution/stores/admin-institution.action";
import {AdminInstitutionStateModel} from "@admin/institution/stores/admin-institution.state";
import {Institution} from "@app/generated-api";
import {SharedAbstractListRoutable} from "@shared/components/routables/shared-abstract-list/shared-abstract-list.routable";
import {FieldTypeEnum} from "@shared/enums/field-type.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {Store} from "@ngxs/store";
import {TRANSLATE} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-institution-list-routable",
  templateUrl: "../../../../../../shared/components/routables/shared-abstract-list/shared-abstract-list.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-list/shared-abstract-list.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminInstitutionListRoutable extends SharedAbstractListRoutable<Institution, AdminInstitutionStateModel> {
  readonly KEY_CREATE_BUTTON: string = TRANSLATE("admin.institution.button.new");
  readonly KEY_REFRESH_BUTTON: string = TRANSLATE("admin.institution.button.refresh");

  constructor(protected store: Store) {
    super(store, LocalStateEnum.admin_institution, adminInstitutionActionNameSpace, {}, LocalStateEnum.admin);
  }

  defineColumns(): void {
    this.columns = [
      {
        field: "name",
        header: TRANSLATE("admin.institution.table.header.name"),
        type: FieldTypeEnum.string,
        order: 0,
        isFilterable: true,
        isSortable: true,
      },
      {
        field: "creation.when" as any,
        header: TRANSLATE("admin.institution.table.header.creation.when"),
        type: FieldTypeEnum.datetime,
        order: 0,
        isFilterable: true,
        isSortable: true,
      },
      {
        field: "lastUpdate.when" as any,
        header: TRANSLATE("admin.institution.table.header.lastUpdate.when"),
        type: FieldTypeEnum.datetime,
        order: 0,
        isFilterable: true,
        isSortable: true,
      },
    ];
  }
}
