import {ChangeDetectionStrategy, Component, OnInit,} from "@angular/core";
import {ActivatedRoute} from "@angular/router";
import {adminInstitutionActionNameSpace} from "@admin/institution/stores/admin-institution.action";
import {AdminInstitutionStateModel} from "@admin/institution/stores/admin-institution.state";
import {Institution} from "@app/generated-api";
import {SharedAbstractEditRoutable} from "@shared/components/routables/shared-abstract-edit/shared-abstract-edit.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {Store} from "@ngxs/store";

@Component({
  selector: "dlcm-admin-institution-edit-routable",
  templateUrl: "./admin-institution-edit.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-edit/shared-abstract-edit.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminInstitutionEditRoutable extends SharedAbstractEditRoutable<Institution, AdminInstitutionStateModel> implements OnInit {
  constructor(protected store: Store,
              protected route: ActivatedRoute) {
    super(store, route, LocalStateEnum.admin_institution, adminInstitutionActionNameSpace, LocalStateEnum.admin);
  }

  getSubResourceWithParentId(id: string): void {
  }
}
