import {ChangeDetectionStrategy, Component,} from "@angular/core";
import {MatDialog} from "@angular/material";
import {ActivatedRoute} from "@angular/router";
import {adminInstitutionActionNameSpace} from "@admin/institution/stores/admin-institution.action";
import {AdminInstitutionStateModel} from "@admin/institution/stores/admin-institution.state";
import {Institution} from "@app/generated-api";
import {SharedAbstractDetailRoutable} from "@shared/components/routables/shared-abstract-detail/shared-abstract-detail.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {Store} from "@ngxs/store";
import {TRANSLATE} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-institution-detail-routable",
  templateUrl: "./admin-institution-detail.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-detail/shared-abstract-detail.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminInstitutionDetailRoutable extends SharedAbstractDetailRoutable<Institution, AdminInstitutionStateModel> {
  readonly KEY_PARAM_NAME: string = "name";
  readonly KEY_DELETE_BUTTON: string = TRANSLATE("admin.institution.button.delete");
  readonly KEY_EDIT_BUTTON: string = TRANSLATE("admin.institution.button.edit");

  constructor(protected store: Store,
              protected route: ActivatedRoute,
              public dialog: MatDialog) {
    super(store, route, dialog, LocalStateEnum.admin_institution, adminInstitutionActionNameSpace, LocalStateEnum.admin);
  }

  getSubResourceWithParentId(id: string): void {
  }
}
