import {ChangeDetectionStrategy, Component, OnInit, ViewChild,} from "@angular/core";
import {adminInstitutionActionNameSpace} from "@admin/institution/stores/admin-institution.action";
import {AdminInstitutionStateModel} from "@admin/institution/stores/admin-institution.state";
import {Institution} from "@app/generated-api";
import {SharedAbstractFormPresentational} from "@shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational";
import {SharedAbstractCreateRoutable} from "@shared/components/routables/shared-abstract-create/shared-abstract-create.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {Store} from "@ngxs/store";

@Component({
  selector: "dlcm-admin-institution-create-routable",
  templateUrl: "./admin-institution-create.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-create/shared-abstract-create.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminInstitutionCreateRoutable extends SharedAbstractCreateRoutable<Institution, AdminInstitutionStateModel> implements OnInit {
  @ViewChild("formPresentational", {static: false})
  readonly formPresentational: SharedAbstractFormPresentational<Institution>;

  constructor(protected store: Store) {
    super(store, LocalStateEnum.admin_institution, adminInstitutionActionNameSpace, LocalStateEnum.admin);
  }
}
