import {ChangeDetectionStrategy, ChangeDetectorRef, Component,} from "@angular/core";
import {FormBuilder, Validators,} from "@angular/forms";
import {Institution} from "@app/generated-api";
import {SharedAbstractFormPresentational} from "@shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational";
import {BaseFormDefinition} from "@shared/models/base-form-definition.model";
import {PropertyName, SolidifyValidator,} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-institution-form",
  templateUrl: "./admin-institution-form.presentational.html",
  styleUrls: ["../../../../../shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminInstitutionFormPresentational extends SharedAbstractFormPresentational<Institution> {
  public formDefinition: FormComponentFormDefinition = new FormComponentFormDefinition();

  constructor(protected readonly _changeDetectorRef: ChangeDetectorRef,
              private readonly _fb: FormBuilder) {
    super(_changeDetectorRef);
  }

  protected initNewForm(): void {
    this.form = this._fb.group({
      [this.formDefinition.name]: ["", [Validators.required, SolidifyValidator]],
      [this.formDefinition.url]: ["", [SolidifyValidator]],
      [this.formDefinition.description]: ["", [SolidifyValidator]],
    });
  }

  protected bindFormTo(institutions: Institution): void {
    this.form = this._fb.group({
      [this.formDefinition.name]: [institutions.name, [Validators.required, SolidifyValidator]],
      [this.formDefinition.url]: [institutions.url, [SolidifyValidator]],
      [this.formDefinition.description]: [institutions.description, [SolidifyValidator]],
    });
  }

  protected treatmentBeforeSubmit(institutions: Institution): Institution {
    return institutions;
  }
}

class FormComponentFormDefinition extends BaseFormDefinition {
  @PropertyName() name: string;
  @PropertyName() url: string;
  @PropertyName() description: string;
}
