import {adminFundingAgenciesOrgUnitActionNameSpace} from "@admin/funding-agencies/stores/organizational-unit/admin-organizational-unit-preservation-policy.action";
import {OrganizationalUnit} from "@app/generated-api";
import {ApiResourceNameEnum} from "@shared/enums/api-resource-name.enum";
import {AdminResourceApiEnum} from "@shared/enums/api.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";

import {Actions, State, Store,} from "@ngxs/store";
import {
  ApiService,
  AssociationState,
  AssociationStateModel,
  defaultAssociationStateInitValue,
  NotificationService,
} from "solidify-frontend";

export interface AdminFundingAgenciesOrganizationalUnitStateModel extends AssociationStateModel<OrganizationalUnit> {
}

@State<AdminFundingAgenciesOrganizationalUnitStateModel>({
  name: LocalStateEnum.admin_fundingAgencies_organizationalUnit,
  defaults: {
    ...defaultAssociationStateInitValue,
  },
})
export class AdminFundingAgenciesOrganizationalUnitState extends AssociationState<OrganizationalUnit> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: adminFundingAgenciesOrgUnitActionNameSpace,
      urlResource: AdminResourceApiEnum.fundingAgencies,
      resourceName: ApiResourceNameEnum.ORG_UNIT,
    });
  }
}
