import {adminFundingAgenciesOrgUnitActionNameSpace} from "@admin/funding-agencies/stores/organizational-unit/admin-organizational-unit-preservation-policy.action";
import {
  AdminFundingAgenciesOrganizationalUnitState,
  AdminFundingAgenciesOrganizationalUnitStateModel,
} from "@admin/funding-agencies/stores/organizational-unit/admin-organizational-unit-preservation-policy.state";
import {
  AdminFundingAgenciesAction,
  adminFundingAgenciesActionNameSpace,
} from "@admin/funding-agencies/stores/admin-funding-agencies.action";
import {AdminResourceApiEnum} from "@shared/enums/api.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {RoutesEnum} from "@shared/enums/routes.enum";
import {FundingAgencyExtended} from "@deposit/models/funding-agency-extended.model";
import {Action, Actions, ofActionCompleted, State, StateContext, Store,} from "@ngxs/store";
import {LocalModelAttributeEnum} from "@shared/enums/model-attribute.enum";
import {SharedOrgUnitAction} from "@shared/stores/organizational-unit/shared-organizational-unit.action";
import _ from "lodash";
import {Observable} from "rxjs";
import {tap} from "rxjs/operators";
import {
  ApiService,
  AssociationActionHelper,
  ChangeModeEnum,
  defaultResourceStateInitValue,
  NotificationService,
  OverrideDefaultAction,
  ResourceState,
  ResourceStateModel,
  StoreUtil,
  TRANSLATE,
} from "solidify-frontend";

export interface AdminFundingAgenciesStateModel extends ResourceStateModel<FundingAgencyExtended> {
  admin_fundingAgencies_organizationalUnit?: AdminFundingAgenciesOrganizationalUnitStateModel;
}

@State<AdminFundingAgenciesStateModel>({
  name: LocalStateEnum.admin_fundingAgencies,
  defaults: {
    ...defaultResourceStateInitValue,
  },
  children: [
    AdminFundingAgenciesOrganizationalUnitState,
  ],
})
export class AdminFundingAgenciesState extends ResourceState<FundingAgencyExtended> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: adminFundingAgenciesActionNameSpace,
      urlResource: AdminResourceApiEnum.fundingAgencies,
      routeRedirectUrlAfterSuccessAction: RoutesEnum.admin,
      notificationResourceCreateTextToTranslate: TRANSLATE("admin.funding-agencies.notification.resource.create"),
      notificationResourceDeleteTextToTranslate: TRANSLATE("admin.funding-agencies.notification.resource.delete"),
      notificationResourceUpdateTextToTranslate: TRANSLATE("admin.funding-agencies.notification.resource.update"),
    });
  }

  @Action(AdminFundingAgenciesAction.LoadResource)
  loadResource(ctx: StateContext<AdminFundingAgenciesStateModel>, action: AdminFundingAgenciesAction.LoadResource): void {
    ctx.patchState({
      isLoadingCounter: ctx.getState().isLoadingCounter + 1,
    });

    ctx.dispatch([
      new SharedOrgUnitAction.GetAll(),
      new AdminFundingAgenciesAction.LoadResourceSuccess(action),
    ]);
  }

  @Action(AdminFundingAgenciesAction.LoadResourceSuccess)
  loadResourceSuccess(ctx: StateContext<AdminFundingAgenciesStateModel>, action: AdminFundingAgenciesAction.LoadResourceSuccess): void {
    ctx.patchState({
      isLoadingCounter: ctx.getState().isLoadingCounter - 1,
    });
  }

  @Action(AdminFundingAgenciesAction.LoadResourceFail)
  loadResourceFail(ctx: StateContext<AdminFundingAgenciesStateModel>, action: AdminFundingAgenciesAction.LoadResourceFail): void {
    ctx.patchState({
      isLoadingCounter: ctx.getState().isLoadingCounter - 1,
    });
  }

  @OverrideDefaultAction()
  @Action(AdminFundingAgenciesAction.Create)
  create(ctx: StateContext<AdminFundingAgenciesStateModel>, action: AdminFundingAgenciesAction.Create): Observable<FundingAgencyExtended> {
    return super.internalCreate(ctx, action)
      .pipe(
        tap(model => {
          const oldOrgUnit = [];
          const newOrgUnit = action.modelFormControlEvent.model[LocalModelAttributeEnum.organizationalUnits];
          const updateSubResourceAction = AssociationActionHelper.update(adminFundingAgenciesOrgUnitActionNameSpace, model.resId, oldOrgUnit, newOrgUnit);
          StoreUtil.updateSubResource(ChangeModeEnum.create, this.actions$, ctx, updateSubResourceAction, adminFundingAgenciesActionNameSpace, adminFundingAgenciesOrgUnitActionNameSpace);
        }),
      );
  }

  @OverrideDefaultAction()
  @Action(AdminFundingAgenciesAction.Update)
  update(ctx: StateContext<AdminFundingAgenciesStateModel>, action: AdminFundingAgenciesAction.Update): Observable<FundingAgencyExtended> {
    return super.internalUpdate(ctx, action)
      .pipe(
        tap(model => {
          const oldOrgUnit = _.map(ctx.getState().admin_fundingAgencies_organizationalUnit.selected, LocalModelAttributeEnum.resId);
          const newOrgUnit = action.modelFormControlEvent.model[LocalModelAttributeEnum.organizationalUnits];
          const updateSubResourceAction = AssociationActionHelper.update(adminFundingAgenciesOrgUnitActionNameSpace, model.resId, oldOrgUnit, newOrgUnit);
          StoreUtil.updateSubResource(ChangeModeEnum.update, this.actions$, ctx, updateSubResourceAction, adminFundingAgenciesActionNameSpace, adminFundingAgenciesOrgUnitActionNameSpace);
        }),
      );
  }

  @OverrideDefaultAction()
  @Action(AdminFundingAgenciesAction.Delete)
  delete(ctx: StateContext<AdminFundingAgenciesStateModel>, action: AdminFundingAgenciesAction.Delete): Observable<FundingAgencyExtended> | any {
    const oldOrgUnit = _.map(ctx.getState().admin_fundingAgencies_organizationalUnit.selected, LocalModelAttributeEnum.resId);

    StoreUtil.dispatchActionAndWaitForSubActionsCompletion(
      ctx,
      [
        {
          action: new adminFundingAgenciesOrgUnitActionNameSpace.DeleteList(action.resId, oldOrgUnit),
          subActionCompletions: [
            this.actions$.pipe(ofActionCompleted(adminFundingAgenciesOrgUnitActionNameSpace.DeleteListSuccess)),
            this.actions$.pipe(ofActionCompleted(adminFundingAgenciesOrgUnitActionNameSpace.DeleteListFail)),
          ],
        },
      ],
    ).subscribe(deleteSubResourceWithSuccess => {
      if (deleteSubResourceWithSuccess) {
        super.delete(ctx, action).subscribe();
      } else {
        super.deleteFail(ctx, action);
      }
    });
  }
}
