import {NgModule} from "@angular/core";
import {SharedModule} from "@app/shared/shared.module";
import {TranslateModule} from "@ngx-translate/core";
import {NgxsModule} from "@ngxs/store";
import {AdminFundingAgenciesListRoutable} from "@admin/funding-agencies/components/routables/list/admin-funding-agencies-list-routable.component";
import {AdminFundingAgenciesDetailRoutable} from "@admin/funding-agencies/components/routables/detail/admin-funding-agencies-detail.routable";
import {AdminFundingAgenciesEditRoutable} from "@admin/funding-agencies/components/routables/edit/admin-funding-agencies-edit.routable";
import {AdminFundingAgenciesCreateRoutable} from "@admin/funding-agencies/components/routables/create/admin-funding-agencies-create.routable";
import {AdminFundingAgencyDeleteDialog} from "@admin/funding-agencies/components/dialogs/admin-funding-agency-delete.dialog";
import {AdminFundingAgenciesFormPresentational} from "@admin/funding-agencies/components/presentationals/admin-funding-agencies-form.presentational";
import {AdminFundingAgenciesState} from "@admin/funding-agencies/stores/admin-funding-agencies.state";
import {AdminFundingAgenciesRoutingModule} from "@admin/funding-agencies/funding-agencies-routing.module";

const routables = [
  AdminFundingAgenciesListRoutable,
  AdminFundingAgenciesDetailRoutable,
  AdminFundingAgenciesEditRoutable,
  AdminFundingAgenciesCreateRoutable,
];
const containers = [];
const dialogs = [
  AdminFundingAgencyDeleteDialog
];
const presentationals = [
  AdminFundingAgenciesFormPresentational
];

@NgModule({
  declarations: [
    ...routables,
    ...containers,
    ...dialogs,
    ...presentationals,
  ],
  imports: [
    SharedModule,
    AdminFundingAgenciesRoutingModule,
    TranslateModule.forChild({}),
    NgxsModule.forFeature([
      AdminFundingAgenciesState
    ]),
  ],
  entryComponents: [
    ...dialogs,
  ],
  exports: [
    ...routables,
  ],
  providers: [],
})
export class AdminFundingAgenciesModule { }
