import {NgModule} from "@angular/core";
import {RouterModule, Routes} from "@angular/router";
import {AdminRoutesEnum, AppRoutesEnum} from "@shared/enums/routes.enum";
import {AdminFundingAgenciesListRoutable} from "@admin/funding-agencies/components/routables/list/admin-funding-agencies-list-routable.component";
import {TRANSLATE} from "solidify-frontend";
import {AdminFundingAgenciesDetailRoutable} from "@admin/funding-agencies/components/routables/detail/admin-funding-agencies-detail.routable";
import {AdminFundingAgenciesEditRoutable} from "@admin/funding-agencies/components/routables/edit/admin-funding-agencies-edit.routable";
import {AdminFundingAgenciesCreateRoutable} from "@admin/funding-agencies/components/routables/create/admin-funding-agencies-create.routable";

const routes: Routes = [
  {
    path: AppRoutesEnum.root,
    component: AdminFundingAgenciesListRoutable,
    data: {
      breadcrumb: TRANSLATE("breadcrumb.admin.funding-agencies.list"),
    },
  },
  {
    path: AdminRoutesEnum.fundingAgenciesDetail + AppRoutesEnum.separator + AppRoutesEnum.paramId,
    component: AdminFundingAgenciesDetailRoutable,
    data: {
      breadcrumb: TRANSLATE("breadcrumb.admin.funding-agencies.detail"),
    },
  },
  {
    path: AdminRoutesEnum.fundingAgenciesEdit + AppRoutesEnum.separator + AppRoutesEnum.paramId,
    component: AdminFundingAgenciesEditRoutable,
    data: {
      breadcrumb: TRANSLATE("breadcrumb.admin.funding-agencies.detail"),
    },
  },
  {
    component: AdminFundingAgenciesCreateRoutable,
    path: AdminRoutesEnum.fundingAgenciesCreate,
    data: {
      breadcrumb: TRANSLATE("breadcrumb.admin.funding-agencies.create"),
    },
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class AdminFundingAgenciesRoutingModule { }
