import {ChangeDetectionStrategy, Component,} from "@angular/core";
import {adminFundingAgenciesActionNameSpace} from "@admin/funding-agencies/stores/admin-funding-agencies.action";
import {AdminFundingAgenciesStateModel} from "@admin/funding-agencies/stores/admin-funding-agencies.state";
import {FundingAgency} from "@app/generated-api";
import {SharedAbstractListRoutable} from "@shared/components/routables/shared-abstract-list/shared-abstract-list.routable";
import {FieldTypeEnum} from "@shared/enums/field-type.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {Store} from "@ngxs/store";
import {TRANSLATE} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-submission-policy-list-routable",
  templateUrl: "../../../../../../shared/components/routables/shared-abstract-list/shared-abstract-list.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-list/shared-abstract-list.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminFundingAgenciesListRoutable extends SharedAbstractListRoutable<FundingAgency, AdminFundingAgenciesStateModel> {
  readonly KEY_CREATE_BUTTON: string = TRANSLATE("admin.funding-agencies.button.new");
  readonly KEY_REFRESH_BUTTON: string = TRANSLATE("admin.funding-agencies.button.refresh");

  constructor(protected store: Store) {
    super(store, LocalStateEnum.admin_fundingAgencies, adminFundingAgenciesActionNameSpace, {}, LocalStateEnum.admin);
  }

  defineColumns(): void {
    this.columns = [
      {
        field: "acronym",
        header: TRANSLATE("admin.funding-agencies.table.header.acronym"),
        type: FieldTypeEnum.string,
        order: 0,
        isFilterable: true,
        isSortable: true,
      },
      {
        field: "name",
        header: TRANSLATE("admin.funding-agencies.table.header.name"),
        type: FieldTypeEnum.string,
        order: 0,
        isFilterable: true,
        isSortable: true,
      },
    ];
  }
}
