import {AdminFundingAgenciesOrgUnitAction} from "@admin/funding-agencies/stores/organizational-unit/admin-organizational-unit-preservation-policy.action";
import {ChangeDetectionStrategy, Component,} from "@angular/core";
import {MatDialog} from "@angular/material";
import {ActivatedRoute} from "@angular/router";
import {adminFundingAgenciesActionNameSpace} from "@admin/funding-agencies/stores/admin-funding-agencies.action";
import {AdminFundingAgenciesStateModel} from "@admin/funding-agencies/stores/admin-funding-agencies.state";
import {FundingAgency, OrganizationalUnit,} from "@app/generated-api";
import {SharedAbstractDetailRoutable} from "@shared/components/routables/shared-abstract-detail/shared-abstract-detail.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {OrganizationalUnitExtended} from "@deposit/models/organizational-unit-extended.model";
import {Select, Store,} from "@ngxs/store";
import {LocalStateModel} from "@shared/models/local-state.model";
import {Observable} from "rxjs";
import {StoreUtil, TRANSLATE,} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-funding-agency-detail-routable",
  templateUrl: "./admin-funding-agencies-detail.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-detail/shared-abstract-detail.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminFundingAgenciesDetailRoutable extends SharedAbstractDetailRoutable<FundingAgency, AdminFundingAgenciesStateModel> {
  @Select((state: LocalStateModel) => StoreUtil.isLoadingState(state.admin.admin_fundingAgencies.admin_fundingAgencies_organizationalUnit)) isLoadingOrgUnitObs: Observable<boolean>;
  @Select((state: LocalStateModel) => state.shared.shared_organizationalUnit.list) listOrgUnitsObs: Observable<OrganizationalUnitExtended[]>;
  @Select((state: LocalStateModel) => state.admin.admin_fundingAgencies.admin_fundingAgencies_organizationalUnit.selected) selectedOrgUnitsObs: Observable<OrganizationalUnit[]>;

  readonly KEY_PARAM_NAME: string = "name";
  readonly KEY_DELETE_BUTTON: string = TRANSLATE("admin.funding-agencies.button.delete");
  readonly KEY_EDIT_BUTTON: string = TRANSLATE("admin.funding-agencies.button.edit");

  constructor(protected store: Store,
              protected route: ActivatedRoute,
              public dialog: MatDialog) {
    super(store, route, dialog, LocalStateEnum.admin_fundingAgencies, adminFundingAgenciesActionNameSpace, LocalStateEnum.admin);
  }

  getSubResourceWithParentId(id: string): void {
    this.store.dispatch(new AdminFundingAgenciesOrgUnitAction.GetAll(id));
  }
}
