import {ChangeDetectionStrategy, Component,} from "@angular/core";
import {adminFundingAgenciesActionNameSpace} from "@admin/funding-agencies/stores/admin-funding-agencies.action";
import {AdminFundingAgenciesStateModel} from "@admin/funding-agencies/stores/admin-funding-agencies.state";
import {FundingAgency} from "@app/generated-api";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {OrganizationalUnitExtended} from "@deposit/models/organizational-unit-extended.model";
import {Select, Store,} from "@ngxs/store";
import {SharedAbstractCreateRoutable} from "@shared/components/routables/shared-abstract-create/shared-abstract-create.routable";
import {LocalStateModel} from "@shared/models/local-state.model";
import {Observable} from "rxjs";

@Component({
  selector: "dlcm-admin-funding-agency-create-routable",
  templateUrl: "./admin-funding-agencies-create.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-detail/shared-abstract-detail.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminFundingAgenciesCreateRoutable extends SharedAbstractCreateRoutable<FundingAgency, AdminFundingAgenciesStateModel> {
  @Select((state: LocalStateModel) => state.shared.shared_organizationalUnit.list) listOrgUnitsObs: Observable<OrganizationalUnitExtended[]>;

  constructor(protected store: Store) {
    super(store, LocalStateEnum.admin_fundingAgencies, adminFundingAgenciesActionNameSpace, LocalStateEnum.admin);
  }

}
