import {ChangeDetectionStrategy, ChangeDetectorRef, Component, Input,} from "@angular/core";
import {FormBuilder, Validators,} from "@angular/forms";
import {OrganizationalUnit} from "@app/generated-api";
import {SharedAbstractFormPresentational} from "@shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational";
import {BaseFormDefinition} from "@shared/models/base-form-definition.model";
import {FundingAgencyExtended} from "@deposit/models/funding-agency-extended.model";
import {LocalModelAttributeEnum} from "@shared/enums/model-attribute.enum";
import _ from "lodash";
import {PropertyName, SolidifyValidator,} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-funding-agencies-form",
  templateUrl: "./admin-funding-agencies-form.presentational.html",
  styleUrls: ["../../../../../shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminFundingAgenciesFormPresentational extends SharedAbstractFormPresentational<FundingAgencyExtended> {
  formDefinition: FormComponentFormDefinition = new FormComponentFormDefinition();

  @Input()
  selectedOrgUnits: OrganizationalUnit[];

  @Input()
  listOrgUnits: OrganizationalUnit[];

  constructor(protected readonly _changeDetectorRef: ChangeDetectorRef,
              private readonly _fb: FormBuilder) {
    super(_changeDetectorRef);
  }

  protected initNewForm(): void {
    this.form = this._fb.group({
      [this.formDefinition.acronym]: ["", [Validators.required, SolidifyValidator]],
      [this.formDefinition.name]: ["", [Validators.required, SolidifyValidator]],
      [this.formDefinition.description]: ["", [SolidifyValidator]],
      [this.formDefinition.url]: ["", [SolidifyValidator]],
      [this.formDefinition.organizationalUnits]: [],
    });
  }

  protected bindFormTo(fundingAgency: FundingAgencyExtended): void {
    this.form = this._fb.group({
      [this.formDefinition.acronym]: [fundingAgency.acronym, [Validators.required, SolidifyValidator]],
      [this.formDefinition.name]: [fundingAgency.name, [Validators.required, SolidifyValidator]],
      [this.formDefinition.description]: [fundingAgency.description, [SolidifyValidator]],
      [this.formDefinition.url]: [fundingAgency.url, [SolidifyValidator]],
      [this.formDefinition.organizationalUnits]: [_.map(this.selectedOrgUnits, LocalModelAttributeEnum.resId)],
    });
  }

  protected treatmentBeforeSubmit(fundingAgency: FundingAgencyExtended): FundingAgencyExtended {
    return fundingAgency;
  }
}

class FormComponentFormDefinition extends BaseFormDefinition {
  @PropertyName() acronym: string;
  @PropertyName() name: string;
  @PropertyName() description: string;
  @PropertyName() organizationalUnits: string;
  @PropertyName() url: string;
}
