import {
  ChangeDetectionStrategy,
  Component,
} from "@angular/core";
import {SharedAbstractPresentational} from "@app/shared/components/presentationals/shared-abstract/shared-abstract.presentational";
import {ApplicationRolePermissionEnum} from "@app/shared/enums/application-role-permission.enum";
import {ApplicationRoleEnum} from "@app/shared/enums/application-role.enum";
import {RoutesEnum} from "@app/shared/enums/routes.enum";
import {LocalStateModel} from "@app/shared/models/local-state.model";
import {PermissionUtil} from "@app/shared/utils/permission.util";
import {Navigate} from "@ngxs/router-plugin";
import {Store} from "@ngxs/store";
import {TRANSLATE} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-home-routable",
  templateUrl: "./admin-home.routable.html",
  styleUrls: ["./admin-home.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminHomeRoutable extends SharedAbstractPresentational {

  userRolesObs: ApplicationRoleEnum[];

  adminResources: AdminResource[] = [
    {
      avatarIcon: "building",
      titleToTranslate: TRANSLATE("admin.organizationalUnit.home.title"),
      subtitleToTranslate: TRANSLATE("admin.organizationalUnit.home.subtitle"),
      path: RoutesEnum.adminOrganizationalUnit,
      isVisible: () => true,
    },
    {
      avatarIcon: "user-check",
      titleToTranslate: TRANSLATE("admin.submissionPolicy.home.title"),
      subtitleToTranslate: TRANSLATE("admin.submissionPolicy.home.subtitle"),
      path: RoutesEnum.adminSubmissionPolicy,
      isVisible: () => true,
    },
    {
      avatarIcon: "copyright",
      titleToTranslate: TRANSLATE("admin.license.home.title"),
      subtitleToTranslate: TRANSLATE("admin.license.home.subtitle"),
      path: RoutesEnum.adminLicense,
      isVisible: () => true,
    },
    {
      avatarIcon: "history",
      titleToTranslate: TRANSLATE("admin.preservationPolicy.home.title"),
      subtitleToTranslate: TRANSLATE("admin.preservationPolicy.home.subtitle"),
      path: RoutesEnum.adminPreservationPolicy,
      isVisible: () => true,
    },
    {
      avatarIcon: "university",
      titleToTranslate: TRANSLATE("admin.institution.home.title"),
      subtitleToTranslate: TRANSLATE("admin.institution.home.subtitle"),
      path: RoutesEnum.adminInstitution,
      isVisible: () => true,
    },
    {
      avatarIcon: "user-circle",
      titleToTranslate: TRANSLATE("admin.user.home.title"),
      subtitleToTranslate: TRANSLATE("admin.user.home.subtitle"),
      path: RoutesEnum.adminUser,
      isVisible: () => PermissionUtil.isUserHavePermission(ApplicationRolePermissionEnum.rootPermission, this.userRolesObs),
    },
    {
      avatarIcon: "id-badge",
      titleToTranslate: TRANSLATE("admin.roles.home.title"),
      subtitleToTranslate: TRANSLATE("admin.roles.home.subtitle"),
      path: RoutesEnum.adminRole,
      isVisible: () => PermissionUtil.isUserHavePermission(ApplicationRolePermissionEnum.rootPermission, this.userRolesObs),
    },
    {
      avatarIcon: "passport",
      titleToTranslate: TRANSLATE("admin.oauth2.home.title"),
      subtitleToTranslate: TRANSLATE("admin.oauth2.home.subtitle"),
      path: RoutesEnum.adminOAuth2client,
      isVisible: () => true,
    },
    {
      avatarIcon: "user",
      titleToTranslate: TRANSLATE("admin.person.home.title"),
      subtitleToTranslate: TRANSLATE("admin.person.home.subtitle"),
      path: RoutesEnum.adminPerson,
      isVisible: () => true,
    },
    {
      avatarIcon: "hand-holding-usd",
      titleToTranslate: TRANSLATE("admin.funding-agencies.home.title"),
      subtitleToTranslate: TRANSLATE("admin.funding-agencies.home.subtitle"),
      path: RoutesEnum.adminFundingAgencies,
      isVisible: () => true,
    },
  ];

  constructor(private store: Store) {
    super();
    this.userRolesObs = this.store.selectSnapshot((state: LocalStateModel) => state.application.userRoles);
  }

  navigate(path: RoutesEnum): void {
    this.store.dispatch(new Navigate([path]));
  }

  getAdminResources(): AdminResource[] {
    return this.adminResources.filter((resource) => resource.isVisible() === true);
  }

}

interface AdminResource {
  avatarIcon: string;
  titleToTranslate: string;
  subtitleToTranslate: string;
  path: RoutesEnum;
  isVisible: () => boolean;
}
