import {HttpClientTestingModule} from "@angular/common/http/testing";
import {NO_ERRORS_SCHEMA} from "@angular/core";
import {
  async,
  ComponentFixture,
  TestBed,
} from "@angular/core/testing";
import {ReactiveFormsModule} from "@angular/forms";
import {SharedSearchPresentational} from "@app/shared/components/presentationals/shared-search/shared-search.presentational";
import {TranslateService} from "@ngx-translate/core";
import {NgxsModule} from "@ngxs/store";
import {MockTranslatePipe} from "../../../../../../test-helpers/mock-translate.pipe";
import {MockTranslateService} from "../../../../../../test-helpers/mock-translate.service";

import {AdminHomeRoutable} from "./admin-home.routable";

describe("AdminHomeRoutable", () => {
  let component: AdminHomeRoutable;
  let fixture: ComponentFixture<AdminHomeRoutable>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      imports: [ReactiveFormsModule, HttpClientTestingModule, NgxsModule.forRoot([])],
      declarations: [AdminHomeRoutable, SharedSearchPresentational, MockTranslatePipe],
      providers: [
        {
          provide: TranslateService,
          useClass: MockTranslateService,
        },
      ],
      schemas: [NO_ERRORS_SCHEMA],
    })
      .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(AdminHomeRoutable);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  xit("should create", () => {
    expect(component).toBeTruthy();
  });
});
