import {AdminFundingAgenciesOrganizationalUnitState} from "@admin/funding-agencies/stores/organizational-unit/admin-organizational-unit-preservation-policy.state";
import {NgModule} from "@angular/core";
import {AdminRoutingModule} from "@app/features/admin/admin-routing.module";
import {AdminHomeRoutable} from "@app/features/admin/components/routables/admin-home/admin-home.routable";
import {AdminState} from "@app/features/admin/stores/admin.state";
import {AdminFundingAgenciesState} from "@admin/funding-agencies/stores/admin-funding-agencies.state";
import {AdminInstitutionState} from "@admin/institution/stores/admin-institution.state";
import {AdminLicenseState} from "@admin/license/stores/admin-license.state";
import {AdminOAuth2ClientState} from "@admin/oauth2-client/stores/admin-oauth2-client.state";
import {AdminOrganizationalUnitState} from "@admin/orgunit/stores/admin-organizational-unit.state";
import {AdminOrganizationalUnitPreservationPolicyState} from "@app/features/admin/orgunit/stores/preservation-policy/admin-organizational-unit-preservation-policy.state";
import {AdminOrganizationalUnitSubmissionPolicyState} from "@app/features/admin/orgunit/stores/submission-policy/admin-organizational-unit-submission-policy.state";
import {AdminPersonState} from "@admin/person/stores/admin-person.state";
import {AdminPreservationPolicyState} from "@admin/preservation-policy/stores/admin-preservation-policy.state";
import {AdminRoleState} from "@admin/role/stores/admin-role.state";
import {AdminSubmissionPolicyState} from "@admin/submission-policy/stores/admin-submission-policy.state";
import {AdminUserState} from "@admin/user/stores/admin-user.state";
import {SharedModule} from "@app/shared/shared.module";
import {TranslateModule} from "@ngx-translate/core";
import {NgxsModule} from "@ngxs/store";

const routables = [
  AdminHomeRoutable
];
const containers = [];
const dialogs = [
];
const presentationals = [
];

@NgModule({
  declarations: [
    ...routables,
    ...containers,
    ...dialogs,
    ...presentationals,
  ],
  imports: [
    SharedModule,
    AdminRoutingModule,
    TranslateModule.forChild({}),
    NgxsModule.forFeature([
      AdminState,
      AdminSubmissionPolicyState,
      AdminPreservationPolicyState,
      AdminLicenseState,
      AdminInstitutionState,
      AdminOrganizationalUnitState,
      AdminOrganizationalUnitSubmissionPolicyState,
      AdminOrganizationalUnitPreservationPolicyState,
      AdminUserState,
      AdminOAuth2ClientState,
      AdminPersonState,
      AdminRoleState,
      AdminFundingAgenciesState,
      AdminFundingAgenciesOrganizationalUnitState,
    ]),
  ],
  entryComponents: [
    ...dialogs,
  ],
  exports: [
    ...routables,
  ],
  providers: [],
})
export class AdminModule {
}
