import {NgModule} from "@angular/core";
import {RouterModule, Routes} from "@angular/router";
import {AdminHomeRoutable} from "@app/features/admin/components/routables/admin-home/admin-home.routable";
import {AdminRoutesEnum, AppRoutesEnum} from "@app/shared/enums/routes.enum";
import {ApplicationRoleGuardService} from "@app/shared/guards/application-role-guard.service";
import {CanDeactivateGuard} from "@shared/services/can-deactivate-guard.service";
import {AuthGuardService} from "@shared/guards/auth-guard.service";
import {TRANSLATE} from "solidify-frontend";

const routes: Routes = [
  {
    path: AppRoutesEnum.root,
    component: AdminHomeRoutable,
    data: {},
  },
  {
    path: AdminRoutesEnum.license,
    // @ts-ignore Dynamic import
    loadChildren: () => import("./license/license.module").then(m => m.AdminLicenseModule),
    data: {
      breadcrumb: TRANSLATE("breadcrumb.admin.license.root"),
    },
    canActivate: [AuthGuardService, ApplicationRoleGuardService, CanDeactivateGuard],
  },
  {
    path: AdminRoutesEnum.institution,
    // @ts-ignore Dynamic import
    loadChildren: () => import("./institution/institution.module").then(m => m.AdminInstitutionModule),
    data: {
      breadcrumb: TRANSLATE("breadcrumb.admin.institution.root"),
    },
    canActivate: [AuthGuardService, ApplicationRoleGuardService, CanDeactivateGuard],
  },
  {
    path: AdminRoutesEnum.fundingAgencies,
    // @ts-ignore Dynamic import
    loadChildren: () => import("./funding-agencies/funding-agencies.module").then(m => m.AdminFundingAgenciesModule),
    data: {
      breadcrumb: TRANSLATE("breadcrumb.admin.funding-agencies.root"),
    },
    canActivate: [AuthGuardService, ApplicationRoleGuardService, CanDeactivateGuard],
  },
  {
    path: AdminRoutesEnum.oauth2client,
    // @ts-ignore Dynamic import
    loadChildren: () => import("./oauth2-client/oauth2-client.module").then(m => m.AdminOauth2ClientModule),
    data: {
      breadcrumb: TRANSLATE("breadcrumb.admin.oauth2Client.root"),
    },
    canActivate: [AuthGuardService, ApplicationRoleGuardService, CanDeactivateGuard],
  },
  {
    path: AdminRoutesEnum.organizationalUnit,
    // @ts-ignore Dynamic import
    loadChildren: () => import("./orgunit/orgunit.module").then(m => m.AdminOrgunitModule),
    data: {
      breadcrumb: TRANSLATE("breadcrumb.admin.organizationalUnit.root"),
    },
    canActivate: [AuthGuardService, ApplicationRoleGuardService, CanDeactivateGuard],
  },
  {
    path: AdminRoutesEnum.person,
    // @ts-ignore Dynamic import
    loadChildren: () => import("./person/person.module").then(m => m.AdminPersonModule),
    data: {
      breadcrumb: TRANSLATE("breadcrumb.admin.person.root"),
    },
    canActivate: [AuthGuardService, ApplicationRoleGuardService, CanDeactivateGuard],
  },
  {
    path: AdminRoutesEnum.preservationPolicy,
    // @ts-ignore Dynamic import
    loadChildren: () => import("./preservation-policy/preservation-policy.module").then(m => m.AdminPreservationPolicyModule),
    data: {
      breadcrumb: TRANSLATE("breadcrumb.admin.preservationPolicy.root"),
    },
    canActivate: [AuthGuardService, ApplicationRoleGuardService, CanDeactivateGuard],
  },
  {
    path: AdminRoutesEnum.role,
    // @ts-ignore Dynamic import
    loadChildren: () => import("./role/role.module").then(m => m.AdminRoleModule),
    data: {
      breadcrumb: TRANSLATE("breadcrumb.admin.role.root"),
    },
    canActivate: [AuthGuardService, ApplicationRoleGuardService, CanDeactivateGuard],
  },
  {
    path: AdminRoutesEnum.user,
    // @ts-ignore Dynamic import
    loadChildren: () => import("./user/user.module").then(m => m.AdminUserModule),
    data: {
      breadcrumb: TRANSLATE("breadcrumb.admin.user.root"),
    },
    canActivate: [AuthGuardService, ApplicationRoleGuardService, CanDeactivateGuard],
  }
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class AdminRoutingModule {
}
