/*-
 * %%----------------------------------------------------------------------------------------------
 * DLCM Technology - DLCM Admin - DocumentationDataInitializer.java
 * SPDX-License-Identifier: GPL-2.0-or-later
 * %----------------------------------------------------------------------------------------------%
 * Copyright (C) 2017 - 2022 University of Geneva
 * %----------------------------------------------------------------------------------------------%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * ----------------------------------------------------------------------------------------------%%
 */

package ch.dlcm.service.init;

import java.util.List;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

import ch.dlcm.business.ArchiveStatisticsService;
import ch.dlcm.business.OrganizationalUnitService;
import ch.dlcm.business.PersonService;
import ch.dlcm.business.UserService;
import ch.dlcm.config.DLCMProperties;
import ch.dlcm.model.settings.Person;

@Service
@ConditionalOnProperty(prefix = "dlcm.module.admin", name = "enable")
public class DocumentationDataInitializer {

  private final ArchiveStatisticsService archiveStatisticsService;
  private final PersonService personService;
  private final UserService userService;
  protected final OrganizationalUnitService organizationalUnitService;

  private final boolean shouldGenerateData;
  private final List<DLCMProperties.Documentation.User> testUsers;

  public DocumentationDataInitializer(DLCMProperties dlcmProperties,
          ArchiveStatisticsService archiveStatisticsService,
          PersonService personService,
          UserService userService,
          OrganizationalUnitService organizationalUnitService) {
    this.archiveStatisticsService = archiveStatisticsService;
    this.personService = personService;
    this.userService = userService;
    this.organizationalUnitService = organizationalUnitService;
    this.shouldGenerateData = dlcmProperties.getDocumentation().shouldGenerateData();
    this.testUsers = dlcmProperties.getDocumentation().getUsers();
  }

  @EventListener(ApplicationReadyEvent.class)
  public void initializeDocumentationData() {
    if (this.shouldGenerateData) {
      int index = 0;
      for (final DLCMProperties.Documentation.User testUser : this.testUsers) {
        final Person testPerson = this.personService.createTestPerson(testUser.getName(), index);
        this.userService.createDocumentationUser(testUser, testPerson);
        index++;
      }
      this.organizationalUnitService.initDocumentationData();
      this.archiveStatisticsService.initDocumentationData();
    }
  }
}
